#!/usr/bin/perl

use DBI;
use strict; # always a good idea
use CGI;

my $host = 'localhost';
my $db = 'test';

# we're using the MySQL 'root' user for now.  You may need to change
# the username and password variables below for this code to run 
# on your system.  
# There is rarely a good reason for your CGI scripts to connect to 
# your databases as the root user.  In fact, it's often prudent to create
# a "web" user with limited priviledges for use with your CGI scripts.

my $user = 'root';
my $password = '';
my $c = new CGI();

# done setting up variables. time to send the CGI header information 
# and connect to MySQL

print $c->header();


print $c->start_html(-title=>'MySQL Test');

my $dbh =  DBI->connect("DBI:mysql:$db:$host",$user,$password) 
	or die "Cannot connect to database. Error: $DBI::errstr \n";


# now we're ready to handle any form submissions that may have happened

my $submit = $c->param('submit');
my ($firstname, $lastname, $users_id);

if($submit)
{
	if ($submit eq 'Update')
	{
 		my $fname = $dbh->quote($c->param('firstname'));
		my $lname = $dbh->quote($c->param('lastname'));

		if (!$c->param('users_id'))   
		# no user id.  this must be a new user
		{
	    		$dbh->do("insert into users (firstname, lastname)
					values ($fname, $lname)")
			or print "Unable to insert data: $DBI::errstr";
		}
		else  
		# found a user id. so we are editing an existing record
		{
	    		$dbh->do("update users 
					set firstname = $fname, 
					lastname = $lname 
					where users_id = " . 
					$dbh->quote($c->param('users_id')))
			or print "Unable to update data: $DBI::errstr";
		}
	}   
	elsif ($submit eq 'Delete' and $c->param('users_id'))
	{
		$dbh->do("delete from users 
				where users_id = " . 
				$dbh->quote($c->param('users_id')));
	}

} # end if submit

elsif ($c->param('users_id')) 
# all we have is a user id, so load the data for display in the form below
{
	($firstname, $lastname, $users_id) = 
			$dbh->selectrow_array("select firstname, 
				lastname, users_id from users 
				where users_id = " 
				. $dbh->quote($c->param('users_id')));
}

# done handling form submission. time to print the user list and the form

my $this_script = $c->url();

print <<EOT;
<p>Click <a href="$this_script">here</a> for a blank form. </p>
<table>
EOT

my $empty;

my $rows = $dbh->selectall_arrayref("select firstname, lastname, users_id
						from users 
						order by users_id") or $empty = 1;

if (!$empty) # then we have users to display
{
	print "<tr> <td colspan=2> <b>User List</b> </td> </tr>\n";
}

my ($first,$last,$usersid);

for my $row (@$rows)
{
	($first,$last,$usersid) = @$row;
	print <<EOT 
	<tr>
		<td> $first $last </td> 
		<td><a href="$this_script?users_id=$usersid">Edit</a> </td>
	</tr>
EOT
}

print <<EOT;
<tr><td colspan=2><hr></td></tr>

<form action="$this_script" method="get">
<tr> 
	<td> First Name </td> 
	<td> <input type="text" name="firstname" value="$firstname"> </td>
</tr>
<tr>
	<td> Last Name  </td> 
	<td> <input type="text" name="lastname" value="$lastname"> </td>
</tr>
<tr>
	<td> <input type="submit" name="submit" value="Update"> </td>
	<td> <input type="submit" name="submit" value="Delete">  </td>
</tr>
<input type="hidden" name="users_id" value="$users_id">
</form>
</table>
EOT

$dbh->disconnect();

print $c->end_html();
